### PreferIntegerOrStringForIndexersRule
This rule checks for indexer properties which use unusual types as indexes. Recommended types include **Int32**, **Int64** and **String**. Using other types can be OK if the indexer is providing an abstraction onto a logical data store, but this is often not the case.

**Bad** example:

``` csharp
public bool this [DateTime date] {
    get {
        return false;
    }
}
```
**Good** example:

``` csharp
public bool IsSomethingPlanned (DateTime date)
{
    return false;
}
```
**Notes**

-   This rule is available since Gendarme 2.0
