### PreferXmlAbstractionsRule
This rule fires if an externally visible method or property uses an **XmlDocument**, **XPathDocument** or **XmlNode** argument. The problem with this is that it ties your API to a specific implementation so it is difficult to change later. Instead use abstract types like **IXPathNavigable**, **XmlReader**, **XmlWriter**, or subtypes of **XmlNode**.

**Bad** example (property):

``` csharp
public class Application {
    public XmlDocument UserData {
        get {
            return userData;
        }
    }
}
```
**Good** example (property):

``` csharp
public class Application {
    public IXPathNavigable UserData {
        get {
            return userData;
        }
    }
}
```
**Bad** example (method parameter):

``` csharp
public class Application {
    public bool IsValidUserData (XmlDocument userData)
    {
        /* implementation */
    }
}
```
**Good** example (method parameter):

``` csharp
public class Application {
    public bool IsValidUserData (XmlReader userData)
    {
        /* implementation */
    }
}
```
**Notes**

-   This rule is available since Gendarme 2.6
