### ReviewUseOfInt64BitsToDoubleRule
This rule checks for invalid integer to double conversion using the, confusingly named, **BitConverter.Int64BitsToDouble** method. This method converts the actual bits, i.e. not the value, into a **Double**. The rule will warn when anything other than an **Int64** is being used as a parameter to this method.

**Bad** example:

``` csharp
public double GetRadians (int degrees)
{
    return BitConverter.Int64BitsToDouble (degrees) * Math.PI / 180.0d;
}
```
**Good** example:

``` csharp
public double GetRadians (int degree)
{
    return degrees * Math.PI / 180.0d;
}
```
**Notes**

-   This rule is available since Gendarme 2.0
