## Use COPY instead of ADD for files and folders

### Problematic code:

```dockerfile
FROM python:3.4
ADD requirements.txt /usr/src/app/
```

### Correct code:

```dockerfile
FROM python:3.4
COPY requirements.txt /usr/src/app/
```
### Rationale:

https://docs.docker.com/engine/articles/dockerfile_best-practices/#add-or-copy

> For other items (files, directories) that do not require ADD’s tar auto-extraction capability, you should always use COPY.

Rule also implemented in https://github.com/RedCoolBeans/dockerlint/blob/master/src/checks.coffee

### Exceptions:

> Consequently, the best use for ADD is local tar file auto-extraction into the image.