There are multiple ways to iterate in Python, each with its own benefits.
Users coming from other languages may iterate a sequence by using range and len, as seen below:

    for index in range(len(obj)):
        value = obj[index]
        print(value)

This can be rewritten in a more Pythonic way by using the concept of iterable that Python has.
If the object provides this capability, this can be rewritten more cleanly as:

    for value in obj:
        print(value)


But if both the index of the value and value itself are needed, a more Pythonic way of
writing an iteration, instead of using range and len, is to use the enumerate builtin,
which returns an iterator of pairs, where the first item is the index and the second
one is the value:

    for index, value in enumerate(obj):
        print(index, value)


Using enumerate will make the code more cleaner and will avoid us to call two functions
for retrieving the value.