Enforces the following rules:

* Any of the following operators is surrounded by one space: ==, !=, <>, <=, >=, <, >, =, +=, -=, *=, **=, /=, //=, &=, |=, ^=, %=, >>=, <<=
* Any opening bracket ( (, [, { ) is not followed by any space.
* Any closing bracket ( ), ], } ) is not preceded by any space.
* Any comma is not preceded by any space, and is followed by one space.
* Any block opener colon is not preceded by any space.

Following these rules improves consistency across different developers and in addition leads to better readability,
and thus makes for easier debugging.
See also [PEP 8: Whitespace in Expressions and Statements]
(http://www.python.org/dev/peps/pep-0008/#whitespace-in-expressions-and-statements)

[Source](http://pylint-messages.wikidot.com/messages:c0326)
      