An abstract class is a class which has abstract methods that needs to be reimplemented by
implementation classes. Instantiating this kind of class will result in runtime errors or
subtle bugs, which can trip in production.

For instance, in the following example, the class Implementation can't be instantiated
because it still has an abstract method that wasn't implemented.


    import abc

    class Meta(metaclass=abc.ABCMeta):
    
        @abc.abstractmethod
        def do_operation(self, op):
            pass

        @abc.abstractmethod
        def do_other_operation(self, op):
            pass

    class Implementation(metaclass=Meta):

        def do_operation(self, op):
            ...

    # This will raise an exception.
    Implementation()
        
    