The __slots__ class variables, used for defining slots, needs only strings, iterables or sequences
as a right hand side value, anything else resulting in an error.

For instance, these examples of __slots__ are all correct:

    class SlotString:
        __slots__ = "attribute"

    class SlotList:
        __slots__ = ["attribute1", "attribute2"]

    class SlotIterable:
        __slots__ = ("name{0}".format(index) for index in range(100))

[SOURCE](https://docs.python.org/3/reference/datamodel.html?highlight=__slots__#notes-on-using-slots)