Used when a mutable value as list or dictionary is detected in a default value for an argument.

This is the message that inspired the creation of the PyLint Messages wiki in the first place!!

Ex:

	def my_method(self, arg1, extras=[]):
	    // blah blah...

To a Python novice, this may seem like a reasonable way to default to an empty array for the extras param. What really happens is that this "default" array gets created as a persistent object, and every invocation of my_method that doesn't specify an extras param will be using that same list object—any changes to it will persist and be carried to every other invocation!

See Ned Batchelder's blog post of 14 June 2008 about PyLint, which highlights this problem and suggests some better alternatives.

[SOURCE](http://pylint-messages.wikidot.com/messages:W0102)