package codacy.patterns

import codacy.base.{Pattern, Result}

import scala.meta._

class Custom_Scala_NullCipherDetector extends Pattern{
  override def apply(tree: Tree): Set[Result] = {
    tree.collect{
      case t@init"NullCipher()" =>
        Result(message(t),t)
      case t@init"javax.crypto.NullCipher()" =>
        Result(message(t),t)
    }.toSet
  }

  private[this] def message(tree: Tree) = Message("NullCipher is insecure")
}
