package codacy.patterns

import codacy.base.Pattern

import scala.collection.immutable.Seq
import scala.meta._

case object Custom_Scala_RSAPadding extends Pattern {

  override def apply(tree: Tree) = {

    tree.collect {
      case t@q"Cipher.getInstance(..${aexprssnel: Seq[Term]})" =>
        handleArgument(aexprssnel).map {
          m => Result(m, t)
        }
      case t@q"javax.crypto.Cipher.getInstance(..${aexprssnel: Seq[Term]})" =>
        handleArgument(aexprssnel).map {
          m => Result(m, t)
        }
    }.flatten
  }

  private def handleArgument(argument: Seq[Term]) = {
    argument.headOption.collect {
      case arg@q"$name" if (name.toString().startsWith("\"RSA") && name.toString().endsWith("/NoPadding\"")) || name.toString() == "\"RSA\"" =>
        message
    }
  }

  private[this] def message = Message("No padding specified")
}
