package codacy.patterns

import codacy.base.Pattern

import scala.meta._

case object Custom_Scala_SQLSelectAll extends Pattern {

  override def apply(tree: Tree) = {
    tree.collect {
      case t@q"${lit: Lit}" if hasSQLIssue(lit, hasSQLSelectAll) =>
        Result(message, t)
    }
  }

  private def getStringFromLit(lit: Lit): Option[String] = {
    Option(lit.value).collect {
      case s: String => s
    }
  }

  private def hasSQLIssue(lit: Lit, issueTester: (String) => Boolean): Boolean = {
    getStringFromLit(lit)
      .exists(str => issueTester(str))
  }

  private def hasSQLSelectAll(str: String): Boolean = {
    val IssueRegex = """select\s*\*""".r
    IssueRegex.findFirstIn(str.toLowerCase).nonEmpty
  }

  private def message = Message("Don't use SELECT * in SQL queries")
}
