package codacy.patterns

import codacy.base.Pattern

import scala.meta._

case object Custom_Scala_SprayUnvalidatedRedirect extends Pattern {

  override def apply(tree: Tree): Seq[Result] = {
    if(hasSprayHint(tree)){
      tree.collect{
        case q"parameters(...$_) { ..$stats }" =>
          findRedirect(stats)
        case q"cookie(...$_) { ..$stats }"  =>
          findRedirect(stats)
      }.flatten
    }
    else Seq.empty
  }

  private def findRedirect(stats: Seq[Stat]): Seq[Result] = {
    stats.collect {
      case q"(..$params) => $expr" =>
        expr.collect {
          case tt@q"redirect(..${args: Seq[Term]})" if isOffender(args, params) =>
            Result(message, tt)
        }
    }.flatten
  }

  private[this] def isOffender(args: Seq[Term], argsInput: Seq[Term.Param]): Boolean = {
    args.exists{
      case q"${exprInner: Term}" =>
        val nameOpt = Option(exprInner).collect{
          case q"${ref:Term.Name}.$tname" => ref
          case q"${ref:Term.Name}" => ref
        }

        nameOpt.exists{ case innerName =>
          argsInput.exists{
            case param"..$mods ${paramname:Term.Name}: $atpeopt = $exprop"  =>
              paramname.toString() == innerName.toString()
            case _ => false
          }
        }
      case _ => false
    }
  }

  //this is merely to avoid false positives remove it if the pattern never encounters issues
  private[this] def hasSprayHint(tree:Tree):Boolean = {
    tree.collect{
      case importer"spray.http._" => true
    }.exists(identity)
  }

  private[this] def message = Message("Untrusted Hostname header")
}
