## This `\o` will be a regular 'o' in this context.

### Problematic code:

```sh
# Want literal backslash
echo Yay \o/

# Want other characters
bell=\a
```

### Correct code:

```sh
echo 'Yay \o/'

bell="$(printf '\a')"
```

### Rationale:

You have escaped something that has no special meaning when escaped. The backslash will be simply be ignored.

If the backslash was supposed to be literal, single quote or escape it.

If you wanted it to expand to something, rewrite the expression to use `printf` (or in bash, `$'\t'`). If the sequence in question is `\n`, `\t` or `\r`, you instead get a [[SC1012]] that describes this. 

### Exceptions

None. ShellCheck (as of 2017-07-03, commit 31bb02d6) will not warn when the first letter of a command is unnecessarily escaped, as this is frequently used to suppress aliases interactively. 
[Source](https://github.com/koalaman/shellcheck/wiki/SC1001)

