## Use 'elif' instead of 'else if'.

### Problematic code:

```sh
if [ "$#" -eq 0 ]
then
  echo "Usage: ..."
else if [ "$#" -lt 2 ]
then
  echo "Missing operand"
fi
  
```

### Correct code:

```sh
if [ "$#" -eq 0 ]
then
  echo "Usage: ..."
elif [ "$#" -lt 2 ]
then
  echo "Missing operand"
fi
```
### Rationale:

Many languages allow alternate branches with `else if`, but `sh` is not one of them. Use `elif` instead.

### Exceptions:

`else if` is a valid (though confusing) way of nesting an `if` statement in a parent's `else`. If this is your intention, please use canonical formatting and put a linefeed between `else` and `if`. 

```sh

if x
then
  echo "x"
else     # line break here
  if y
  then
    echo "y"
   fi 
fi
```
[Source](https://github.com/koalaman/shellcheck/wiki/SC1075)

