## Add a linefeed between end token and terminating ')'.

### Problematic code:

```sh
var=$(fmt -s "$COLUMNS" << "eof"
This is a bunch of text
eof)

```

### Correct code:

```sh
var=$(fmt -s "$COLUMNS" << "eof"
This is a bunch of text
eof
)
```
### Rationale:

When embedding a here document in `$(..)` or `(..)`, there needs to be a linefeed (newline) between the here doc token and the closing `)`. Please insert one.

Failing to do so may cause warnings like this:

    bash: warning: here-document at line 15 delimited by end-of-file (wanted `eof')`
    dash: 5: Syntax error: end of file unexpected (expecting ")")

### Exceptions:

This error may be incorrectly emitted for `ksh`, where this is allowed. In this case, please either write it in a standard way or ignore this warning.
[Source](https://github.com/koalaman/shellcheck/wiki/SC1119)

