## Use find instead of ls to better handle non-alphanumeric filenames.

### Problematic code:

```sh
ls -l | grep " $USER " | grep '\.txt$'
```

### Correct code:

```sh
find . -maxdepth 1 -name '*.txt' -user "$USER"
```

### Rationale:

`ls` is only intended for human consumption: it has a loose, non-standard format and may "clean up" filenames to make output easier to read.

Here's an example:

```sh
$ ls -l
total 0
-rw-r----- 1 me me 0 Feb  5 20:11 foo?bar
-rw-r----- 1 me me 0 Feb  5  2011 foo?bar
-rw-r----- 1 me me 0 Feb  5 20:11 foo?bar
```

It shows three seemingly identical filenames, and did you spot the time format change? How it formats and what it redacts can differ between locale settings, `ls` version, and whether output is a tty.

`ls` can usually be substituted for `find` if it's the filenames you're after.

If trying to parse out any other fields, first see whether `stat` (GNU, OS X, FreeBSD) or `find -printf` (GNU) can give you the data you want directly.

### Exceptions:

If the information is intended for the user and not for processing (`ls -l ~/dir | nl; echo "Ok to delete these files?"`) you can ignore this error with a [[directive]].

[Source](https://github.com/koalaman/shellcheck/wiki/SC2012)

