# Grep uses regex, but this looks like a glob.

### Problematic code:

```sh
grep '*foo*'
```

### Correct code:

```sh
grep 'foo'   # or more explicitly,  grep '.*foo.*'
```

### Rationale:

In globs, `*` matches any number of any character.

In regex, `*` matches any number of the preceding character.

`grep` uses regex, not globs, so this means that `grep '*foo'` is nonsensical because there's no preceding character for `*`.

If the intention was to match "any number of characters followed by foo", use `'.*foo'`. Also note that since grep matches substrings, this will match "fishfood". Use anchors to prevent this, e.g. `foo$`.

This also means that `f*` will match "hello", because `f*` matches 0 (or more) "f"s and there are indeed 0 "f" characters in "hello". Again, use `grep 'f'` to find strings containing "f", or `grep '^f'` to find strings starting with "f".


### Exceptions

If you're aware of the differences between globs and regex, you can ignore this message.

[Source](https://github.com/koalaman/shellcheck/wiki/SC2063)

