## Add < /dev/null to prevent ssh from swallowing stdin.

The same error applies to multiple commands, like `ffmpeg` and `mplayer`.

### Problematic code:

```sh
while read -r host
do
  ssh "$host" "uptime"
done < hosts.txt
```

### Correct code:

```sh
while read -r host
do
  ssh "$host" "uptime" < /dev/null
done < hosts.txt
```
### Rationale:

Commands that process stdin will compete with the `read` statement for input. This is especially tricky for commands you wouldn't expect reads from stdin, like `ssh .. uptime`, `ffmpeg` and `mplayer`.

The most common symptom of this is a `while read` loop only running once, even though the input contains many lines. This is because the rest of the lines are swallowed by the offending command.

To refuse such commands input, redirect their stdin with `< /dev/null`.

You can also use command specific options like `ssh -n` and `mplayer -noconsolecontrols`. 

### Exceptions:

None.

### Related resources:

* [BashFaq: I'm reading a file line by line and running ssh or ffmpeg, only the first line gets processed!](https://mywiki.wooledge.org/BashFAQ/089)
* [StackOverflow: Shell script while read line loop stops after the first line
](https://stackoverflow.com/questions/13800225/shell-script-while-read-line-loop-stops-after-the-first-line)
[Source](https://github.com/koalaman/shellcheck/wiki/SC2095)

