## -eq is for integer comparisons. Use = instead.

### Problematic code:

```sh
[[ $foo -eq "Y" ]]
```

### Correct code:

```sh
[[ $foo = "Y" ]]
```

### Rationale:

Shells have two sets of comparison operators: for integers (`-eq`, `-gt`, ...) and strings (`=`, `>`, ...). ShellCheck has noticed that you're using an integer comparison with string data.

If you are in fact comparing integers, double check your parameters. Certain mistakes like `$$foo` or `${bar}}` can introduce non-numeric characters into otherwise numeric arguments.

### Exceptions

None.

[Source](https://github.com/koalaman/shellcheck/wiki/SC2130)

