## Did you mean IFS=$'\t' ?

### Problematic code:

```sh
IFS="\t"
```

### Correct code:

```sh
IFS=$'\t'
```

### Rationale:

`IFS="\t"` splits on backslash and the letter "t". `IFS=$'\t'` splits on tab.

### Exceptions

It's extremely rare to want to split on the letter "n" or "t", rather than linefeed or tab.

[Source](https://github.com/koalaman/shellcheck/wiki/SC2141)

