## Use grep -q instead of comparing output with [ -n .. ].
### Problematic code:

```sh
if [ "$(find . | grep 'IMG[0-9]')" ]
then
  echo "Images found"
fi
```

### Correct code:

```sh
if find . | grep -q 'IMG[0-9]'
then
  echo "Images found"
fi
```

### Rationale:

The problematic code has to iterate the entire directory and read all matching lines into memory before making a decision.

The correct code is cleaner and stops at the first matching line, avoiding both iterating the rest of the directory and reading data into memory.

### Exceptions

The `pipefail` bash option may interfere with this rewrite, since the `if` will now in effect be evaluating the statuses of all commands instead of just the last one. Be careful using them together.

[Source](https://github.com/koalaman/shellcheck/wiki/SC2143)

