## [ 0 ] is true. Use 'false' instead

### Problematic code:

```sh
if [ 0 ]
then
  echo "always triggers"
fi
```

### Correct code:

```sh
if false
then
  echo "never triggers"
fi
```

### Rationale:

`[ str ]` checks whether `str` is non-empty. It doesn't matter if `str` is `0`, it will still be evaluated for non-emptyness.

Instead, use the command `false` which -- as the manual puts it -- does nothing, unsuccessfully.

### Exceptions:

None

[Source](https://github.com/koalaman/shellcheck/wiki/SC2159)

