## Prefer [ p ] && [ q ] as [ p -a q ] is not well defined.

And likewise, prefer `[ p ] || [ q ]` over `[ p -o q ]`.

### Problematic code:

```sh
[ "$1" = "test" -a -z "$2" ]
```

### Correct code:

```sh
[ "$1" = "test" ] && [ -z "$2" ]
```



### Rationale:

`-a` and `-o` to mean AND and OR in a `[ .. ]` test expression is not well defined, and can cause incorrect results when arguments start with dashes or contain `!`. [From POSIX](http://pubs.opengroup.org/onlinepubs/9699919799/utilities/test.html):

>The XSI extensions specifying the -a and -o binary primaries and the '(' and ')' operators have been marked obsolescent. (Many expressions using them are ambiguously defined by the grammar depending on the specific expressions being evaluated.) Scripts using these expressions should be converted to the forms given below. Even though many implementations will continue to support these obsolescent forms, scripts should be extremely careful when dealing with user-supplied input that could be confused with these and other primaries and operators. Unless the application developer knows all the cases that produce input to the script, invocations like:
>
>    `test "$1" -a "$2"`
>
>should be written as:
>
>   `test "$1" && test "$2"`


Using multiple `[ .. ]` expressions with shell AND/OR operators `&&` and `||` is well defined and therefore preferred (but note that they have equal precedence, while `-a`/`-o` is unspecified but usually implemented as `-a` having higher precedence).

### Exceptions:

If the shell variant being used is ksh derived (such as the bash shell) it will have the shell builtin command `[[ ... ]]`. This has the operators `&&`, `||`, `(`, `)`, `!` which safely avoid the ambiguity by noting which arguments were quoted and requiring the operators to be unquoted (except by the `[[ ... ]]` construct itself).

[Source](https://github.com/koalaman/shellcheck/wiki/SC2166)

