## tempfile is deprecated. Use mktemp instead.

### Problematic code:

```sh
tmp=$(tempfile)
```

### Correct code:

```sh
tmp=$(mktemp)
```
### Rationale:

`tempfile` is a Debian specific utility for creating temporary files. Its man page notes:

>tempfile is deprecated; you should use mktemp(1) instead.

Neither `tempfile` nor `mktemp` are POSIX, but `tempfile` is Debian specific while `mktemp` works on GNU, OSX, BusyBox, *BSD and Solaris.

### Exceptions:

ShellCheck will not recognize when a function overrides this name.
[Source](https://github.com/koalaman/shellcheck/wiki/SC2186)

