## Redirecting to 'echo', a command that doesn't read stdin. Bad quoting or missing xargs?

### Problematic code:

```sh
echo << eof
  Hello World
eof
```

### Correct code:

```sh
cat << eof
  Hello World
eof
```

### Rationale:

You are redirecting to one of several commands that don't read from stdin.

This may happen when:

* Confusing one command for another, e.g. using `echo` where `cat` was intended.
* Incorrectly quoting angle brackets, e.g. using `echo <p>Hello` which tries to read from a file `p`.
* Missing `xargs`, e.g. `mv -t dir < files` instead of `xargs mv -t dir < files` (or more safely, `tr '\n' '\0' < files | xargs -0 mv -t dir`), because stdin should be passed as parameters.

Check your logic, and rewrite the command so data is passed correctly.

### Exceptions:

If you've overridden a command to return output, you can either rename it to make this obvious, or [[ignore]] this message.
[Source](https://github.com/koalaman/shellcheck/wiki/SC2217)

