## which is non-standard. Use builtin 'command -v' instead.

### Problematic code:

```sh
which grep
```

### Correct code:

```sh
command -v grep
```

### Rationale:

`which` is a non-standard, external tool that locates an executable in PATH. `command -v` is a POSIX standard builtin, which uses the same lookup mechanism that the shell itself would.

### Exceptions:

None

### Related resources:

* [Check if a program exists from a Bash script](https://stackoverflow.com/a/677212/1899640) on StackOverflow.
[Source](https://github.com/koalaman/shellcheck/wiki/SC2230)

