Shared naming conventions allow teams to collaborate efficiently. This rule checks whether or not type names are camel cased. To reduce noise, two
consecutive upper case characters are allowed unless they form the whole type name. So, `MyXClass` is compliant, but `XC` on its
own is not.

## Noncompliant Code Example

<pre>
class my_class {...}
class SOMEName42 {...}
</pre>

## Compliant Solution

<pre>
class MyClass {...}
class SomeName42 {...}
</pre>

## Exceptions

The rule ignores types that are marked with `ComImportAttribute` or `InterfaceTypeAttribute`. Furthermore, the rule allows to
have `'_'` characters in class names inside test projects.

<pre>
class Some_Name___42 {...} // valid in test
class Some_name___42 {...} // still not valid
class Some_Name_XC {...} // invalid because of XC, should be Some_Name_Xc
</pre>