Empty statements, i.e. `;`, are usually introduced by mistake, for example because:

*   It was meant to be replaced by an actual statement, but this was forgotten.
*   There was a typo which lead the semicolon to be doubled, i.e. `;;`.

## Noncompliant Code Example

<pre>
void doSomething()
{
  ; // Noncompliant - was used as a kind of TODO marker
}

void doSomethingElse()
{
  Console.WriteLine("Hello, world!");;  // Noncompliant - double ;
  ...
  // Rarely, they are used on purpose as the body of a loop. It is a bad practice to
  // have side-effects outside of the loop:
  for (int i = 0; i &lt; 3; Console.WriteLine(i), i++); // Noncompliant
  ...
}
</pre>

## Compliant Solution

<pre>
void doSomething()
{
}

void doSomethingElse()
{
  Console.WriteLine("Hello, world!");
  ...
  for (int i = 0; i &lt; 3; i++)
  {
    Console.WriteLine(i);
   }
  ...
}
</pre>

## See

*   MISRA C:2004, 14.3 - Before preprocessing, a null statement shall only occur on a line by itself; it may be followed by a comment provided that
      the first character following the null statement is a white-space character.
*   MISRA C++:2008, 6-2-3 - Before preprocessing, a null statement shall only occur on a line by itself; it may be followed by a comment, provided
      that the first character following the null statement is a white-space character.
*   [CERT, MSC12-C.](https://www.securecoding.cert.org/confluence/x/NYA5) - Detect and remove code that has no effect or is never
      executed
*   [CERT, MSC12-CPP.](https://www.securecoding.cert.org/confluence/x/SIIyAQ) - Detect and remove code that has no effect
*   [CERT, MSC51-J.](https://www.securecoding.cert.org/confluence/x/7gCTAw) - Do not place a semicolon immediately following an if, for,
      or while condition
*   [CERT, EXP15-C.](https://www.securecoding.cert.org/confluence/x/i4FtAg) - Do not place a semicolon on the same line as an if, for,
      or while statement