Utility classes, which are collections of `static` members, are not meant to be instantiated. Even `abstract` utility
classes, which can be extended, should not have `public` constructors.

C# adds an implicit public constructor to every class which does not explicitly define at least one constructor. Hence, at least one
`protected` constructor should be defined if you wish to subclass this utility class. Or the `static` keyword should be added to
the class declaration to prevent subclassing.

## Noncompliant Code Example

<pre>
public class StringUtils // Noncompliant
{
  public static string Concatenate(string s1, string s2)
  {
    return s1 + s2;
  }
}
</pre>

## Compliant Solution

<pre>
public static class StringUtils
{
  public static string Concatenate(string s1, string s2)
  {
    return s1 + s2;
  }
}
</pre>

or

<pre>
public class StringUtils
{
  protected StringUtils()
  {
  }
  public static string Concatenate(string s1, string s2)
  {
    return s1 + s2;
  }
}
</pre>

## Exceptions

When class contains `public static void main(String[] args)` method it is not considered as utility class and will be ignored by this
rule.