`if` statements with conditions that are always false have the effect of making blocks of code non-functional. `if`
statements with conditions that are always true are completely redundant, and make the code less readable.

There are three possible causes for the presence of such code: 

*   An if statement was changed during debugging and that debug code has been committed.
*   Some value was left unset.
*   Some logic is not doing what the programmer thought it did.

In any of these cases, unconditional `if` statements should be removed.

## Noncompliant Code Example

<pre>
if (true)
{
  DoSomething();
}
...
if (false)
{
  DoSomethingElse();
}

if (2 &lt; 3 ) { ... }  // Noncompliant; always false

int i = 0;
int j = 0;
// ...
j = Foo();

if (j &gt; 0 &amp;&amp; i &gt; 0) { ... }  // Noncompliant; always false - i never set after initialization

bool b = true;
//...
if (b || !b) { ... }  // Noncompliant
</pre>

## Compliant Solution

<pre>
DoSomething();
...
</pre>

## See

*   [MITRE, CWE-489](http://cwe.mitre.org/data/definitions/489.html) - Leftover Debug Code
*   [MITRE, CWE-570](http://cwe.mitre.org/data/definitions/570.html) - Expression is Always False
*   [MITRE, CWE-571](http://cwe.mitre.org/data/definitions/571.html) - Expression is Always True
*   MISRA C:2004, 13.7 - Boolean operations whose results are invariant shall not be permitted.
*   MISRA C:2012, 14.3 - Controlling expressions shall not be invariant

## Deprecated

This rule is deprecated; use {rule:csharpsquid:S2583} instead.