Throwing an exception from within a finally block will mask any exception which was previously thrown in the `try` or `catch`
block, and the masked's exception message and stack trace will be lost.

## Noncompliant Code Example

<pre>
try
{
  /* some work which end up throwing an exception */
  throw new ArgumentException();
}
finally
{
  /* clean up */
  throw new InvalidOperationException();       // Noncompliant; will mask the ArgumentException
}
</pre>

## Compliant Solution

<pre>
try
{
  /* some work which end up throwing an exception */
  throw new ArgumentException();
}
finally
{
  /* clean up */                       // Compliant
}
</pre>

## See

*   [CERT, ERR05-J.](https://www.securecoding.cert.org/confluence/x/soUbAQ) - Do not let checked exceptions escape from a finally block