Overriding a method just to call the same method from the base class without performing any other actions is useless and misleading. The only time
this is justified is in `sealed` overriding methods, where the effect is to lock in the parent class behavior. This rule ignores overrides
of `Equals` and `GetHashCode`.

NOTE: In some cases it might be dangerous to add or remove empty overrides, as they might be breaking changes.

## Noncompliant Code Example

<pre>
public override void Method() // Noncompliant
{
  base.Method();
}
</pre>

## Compliant Solution

<pre>
public override void Method()
{
  //do something else
}
</pre>

## Exceptions

If there is an attribute in any level of the overriding chain, then the overridden member is ignored.

<pre>
public class Base
{
  [Required]
  public virtual string Name { get; set; }
}

public class Derived : Base
{
  public override string Name
  {
    get
    {
      return base.Name;
    }
    set
    {
      base.Name = value;
    }
  }
}
</pre>

If there is a documentation comment on the overriding method, it will be ignored:

<pre>
public class Foo : Bar
{
    /// <summary>
    /// Keep this method for backwards compatibility.
    /// </summary>
    public override void DoSomething()
    {
        base.DoSomething();
    }
}
</pre>