While not technically incorrect, the omission of curly braces can be misleading, and may lead to the introduction of errors during maintenance.

## Noncompliant Code Example

<pre>
// the two statements seems to be attached to the if statement, but that is only true for the first one:
if (condition)
  ExecuteSomething();
  CheckSomething();
</pre>

## Compliant Solution

<pre>
if (condition)
{
  ExecuteSomething();
  CheckSomething();
}
</pre>

## See

*   MISRA C:2004, 14.8 - The statement forming the body of a switch, while, do ... while or for statement shall be a compound statement
*   MISRA C:2004, 14.9 - An if (expression) construct shall be followed by a compound statement. The else keyword shall be followed by either a
      compound statement, or another if statement
*   MISRA C++:2008, 6-3-1 - The statement forming the body of a switch, while, do ... while or for statement shall be a compound statement
*   MISRA C++:2008, 6-4-1 - An if (condition) construct shall be followed by a compound statement. The else keyword shall be followed by either a
      compound statement, or another if statement
*   MISRA C:2012, 15.6 - The body of an iteration-statement or a selection-statement shall be a compound-statement
*   [CERT, EXP19-C.](https://www.securecoding.cert.org/confluence/x/1QGMAg) - Use braces for the body of an if, for, or while statement

*   [CERT, EXP52-J.](https://www.securecoding.cert.org/confluence/x/3wHEAw) - Use braces for the body of an if, for, or while statement