For better readability, do not put more than one statement on a single line.

## Noncompliant Code Example

<pre>
if(someCondition) DoSomething();
</pre>

## Compliant Solution

<pre>
if(someCondition)
{
  DoSomething();
}
</pre>

## Exceptions

Anonymous functions containing a single statement are ignored. Block statements are not considered either.

<pre>
Func
 <object, bool>
   item1 = o =&gt; { return true; }; // Compliant
Func
  <object, bool>
    item1 = o =&gt; { var r = false; return r; }; // Noncompliant 
  </object,>
 </object,></pre>