`string.ToLower()`, `ToUpper`, `IndexOf`, `LastIndexOf`, and `Compare` are all
culture-dependent, as are some (floating point number and `DateTime`-related) calls to `ToString`. Fortunately, all have
variants which accept an argument specifying the culture or formatter to use. Leave that argument off and the call will use the system default
culture, possibly creating problems with international characters.

`string.CompareTo()` is also culture specific, but has no overload that takes a culture information, so instead it's better to use
`CompareOrdinal`, or `Compare` with culture.

Calls without a culture may work fine in the system's "home" environment, but break in ways that are extremely difficult to diagnose for customers
who use different encodings. Such bugs can be nearly, if not completely, impossible to reproduce when it's time to fix them.

## Noncompliant Code Example

<pre>
var lowered = someString.ToLower(); //Noncompliant
</pre>

## Compliant Solution

<pre>
var lowered = someString.ToLower(CultureInfo.InvariantCulture);
</pre>

or

<pre>
var lowered = someString.ToLowerInvariant();
</pre>

## See

*   [CERT, STR02-J.](https://www.securecoding.cert.org/confluence/x/EwAiAg) - Specify an appropriate locale when comparing
      locale-dependent data