When the value of a private field is always assigned to in a class' methods before being read, then it is not being used to store class
information. Therefore, it should become a local variable in the relevant methods to prevent any misunderstanding.

## Noncompliant Code Example

<pre>
public class Foo
{
  private int singularField;

  public void DoSomething(int x)
  {
    singularField = x + 5;

    if (singularField == 0) { /* ... */ }
  }
}
</pre>

## Compliant Solution

<pre>
public class Foo
{
  public void DoSomething(int x)
  {
    int localVariable = x + 5;

    if (localVariable == 0) { /* ... */ }
  }
}
</pre>