Having an unconditional `break`, `return`, `(@)throw` or `goto` in a loop renders it useless; the loop
will only execute once and the loop structure itself is simply wasted keystrokes.

Having an unconditional `continue` in a loop can render the loop meaningless, or is itself wasted keystrokes, depending on where in the
loop it occurs.

Having an unconditional `return` anywhere other than at the end of a function or method simply renders all the rest of the code in the
method useless.

For these reasons, unconditional jump statements should never be used except for the final `return` in a function or method.

## Noncompliant Code Example

<pre>
for (var i = 0; i &lt; 10; i++)
{
    Console.WriteLine(i);
    break;  // loop only executes once
}

for (var i = 0; i &lt; 10; i++)
{
    continue;
    Console.WriteLine(i); // this is never executed
}

for (var i = 0; i &lt; 10; i++)
{
    Console.WriteLine(i);
    continue;  // this is meaningless; the loop would continue anyway
}
</pre>

## Compliant Solution

<pre>
for (var i = 0; i &lt; 10; i++)
{
    Console.WriteLine(i);
}

for (var i = 0; i &lt; 10; i++)
{
    Console.WriteLine(i);
    if (ErrorOccurred())
    {
        break;
    }
}
</pre>

## See

*   MISRA C:2004, 14.1 - There shall be no unreachable code.
*   MISRA C++:2008, 0-1-1 - A _project_ shall not contain _unreachable code_.
*   MISRA C++:2008, 0-1-9 - There shall be no dead code.
*   MISRA C:2012, 2.2 - There shall be no dead code
*   [CERT, MSC12-C.](https://www.securecoding.cert.org/confluence/x/NYA5) - Detect and remove code that has no effect or is never
      executed
*   [CERT, MSC12-CPP.](https://www.securecoding.cert.org/confluence/x/SIIyAQ) - Detect and remove code that has no effect