A dead store happens when a local variable is assigned a value that is not read by any subsequent instruction. Calculating or retrieving a value
only to then overwrite it or throw it away, could indicate a serious error in the code. Even if it's not an error, it is at best a waste of resources.
Therefore all calculated values should be used.

## Noncompliant Code Example

<pre>
void CalculateRate(int a, int b)
{
  int i;

  i = a + b; // Noncompliant; calculation result not used before value is overwritten
  i = DoSomething();  // Noncompliant; retrieved value not used
  for (i = 0; i &lt; 10; i++)
  {
    //  ...
  }
  // ...
}
</pre>

## Compliant Solution

<pre>
void CalculateRate(int a, int b)
{
  int i;

  i = DoSomething();
  i += a + b;
  StoreI(i);

  for (i = 0; i &lt; 10; i++)
  {
    //  ...
  }
}
</pre>

## Exceptions

No issue is reported when 

*   the analyzed method body contains `try` blocks,
*   a lambda expression captures the local variables, or
*   the variable is unused (case covered by Rule S1481)
*   initializations to `-1`, `0`, `1`, `null`, `true`, `false`, `""`
      and `string.Empty`.

## See

*   [MITRE, CWE-563](http://cwe.mitre.org/data/definitions/563.html) - Assignment to Variable without Use ('Unused Variable')
*   [CERT, MSC13-C.](https://www.securecoding.cert.org/confluence/x/QYA5) - Detect and remove unused values
*   [CERT, MSC13-CPP.](https://www.securecoding.cert.org/confluence/x/S4IyAQ) - Detect and remove unused values
*   [CERT, MSC56-J.](https://www.securecoding.cert.org/confluence/x/uQCSBg) - Detect and remove superfluous code and values
*   [CERT, MSC12-CPP.](https://www.securecoding.cert.org/confluence/x/SIIyAQ) - Detect and remove code that has no effect