Invoking a method designed to return a string representation of an object which is already a string is a waste of keystrokes. Similarly, explicitly
invoking `ToString()` when the compiler would do it implicitly is also needless code-bloat.

This rule raises an issue when `ToString()` is invoked:

*   on a `string`
*   on a non-`string` operand to concatenation
*   on an argument to `string.Format`

## Noncompliant Code Example

<pre>
var s = "foo";
var t = "fee fie foe " + s.ToString();  // Noncompliant
var someObject = new object();
var u = "" + someObject.ToString(); // Noncompliant
var v = string.Format("{0}", someObject.ToString()); // Noncompliant
</pre>

## Compliant Solution

<pre>
var s = "foo";
var t = "fee fie foe " + s;
var someObject = new object();
var u = "" + someObject;
var v = string.Format("{0}", someObject);
</pre>

## Exceptions

The rule does not report on value types, where leaving off the `ToString()` call would result in automatic boxing.

<pre>
var v = string.Format("{0}", 1.ToString());
</pre>