The MD5 algorithm and its successor, SHA-1, are no longer considered secure, because it is too easy to create hash collisions with them. That is,
it takes too little computational effort to come up with a different input that produces the same MD5 or SHA-1 hash, and using the new, same-hash
value gives an attacker the same access as if he had the originally-hashed value. This applies as well to the other Message-Digest algorithms: MD2,
MD4, MD6.

This rule tracks usage of the `System.Security.Cryptography.CryptoConfig.CreateFromName()`, and
`System.Security.Cryptography.HashAlgorithm.Create()` methods to instantiate MD5 or SHA-1 algorithms, and of derived class instances of
`System.Security.Cryptography.SHA1` and `System.Security.Cryptography.MD5`.

## Noncompliant Code Example

<pre>
var hashProvider1 = new MD5CryptoServiceProvider(); //Noncompliant
var hashProvider2 = (HashAlgorithm)CryptoConfig.CreateFromName("MD5"); //Noncompliant
var hashProvider3 = new SHA1Managed(); //Noncompliant
var hashProvider4 = HashAlgorithm.Create("SHA1"); //Noncompliant
</pre>

## Compliant Solution

<pre>
var hashProvider1 = new SHA256Managed();
var hashProvider2 = (HashAlgorithm)CryptoConfig.CreateFromName("SHA256Managed");
var hashProvider3 = HashAlgorithm.Create("SHA256Managed");
</pre>

## See

*   [MITRE, CWE-328](http://cwe.mitre.org/data/definitions/328) - Reversible One-Way Hash
*   [MITRE, CWE-327](http://cwe.mitre.org/data/definitions/327) - Use of a Broken or Risky Cryptographic Algorithm
*   [OWASP Top Ten 2013 Category A6](https://www.owasp.org/index.php/Top_10_2013-A6-Sensitive_Data_Exposure) - Sensitive Data Exposure

*   [SANS Top 25](http://www.sans.org/top25-software-errors/) - Porous Defenses
*   Derived from FindSecBugs rule [MessageDigest Is Weak](http://h3xstream.github.io/find-sec-bugs/bugs.htm#WEAK_MESSAGE_DIGEST)