Since C# 5.0, `async` and `await` are contextual keywords. Contextual keywords do have a particular meaning in some contexts,
but can still be used as variable names. Keywords, on the other hand, are always reserved, and therefore are not valid variable names. To avoid any
confusion though, it is best to not use `async` and `await` as identifiers.

## Noncompliant Code Example

<pre>
int await = 42; // Noncompliant
</pre>

## Compliant Solution

<pre>
int someOtherName = 42;
</pre>