Fields should not be part of an API, and therefore should always be private. Indeed, they cannot be added to an interface for instance, and
validation cannot be added later on without breaking backward compatiblity. Instead, developers should encapsulate their fields into properties.
Explicit property getters and setters can be introduced for validation purposes or to smooth the transition to a newer system.

## Noncompliant Code Example

<pre>
public class Foo
{
  public int MagicNumber = 42;
}
</pre>

## Compliant Solution

<pre>
public class Foo
{
  public int MagicNumber
  {
    get { return 42; }
  }
}
</pre>

or 

<pre>
public class Foo
{
  private int MagicNumber = 42;
}
</pre>

## Exceptions

`struct`s are ignored, as are `static` and `const` fields in classes. 

Further, an issue is only raised when the real accessibility is `public`, taking into account the class accessibility.