If a boolean expression doesn't change the evaluation of the condition, then it is entirely unnecessary, and can be removed. If it is gratuitous
because it does not match the programmer's intent, then it's a bug and the expression should be fixed.

## Noncompliant Code Example

<pre>
a = true;
if (a) // Noncompliant
{
  DoSomething();
}

if (b &amp;&amp; a) // Noncompliant; "a" is always "true"
{
  DoSomething();
}

if (c || !a) // Noncompliant; "!a" is always "false"
{
  DoSomething();
}
</pre>

## Compliant Solution

<pre>
a = true;
if (Foo(a))
{
  DoSomething();
}

if (b)
{
  DoSomething();
}

if (c)
{
  DoSomething();
}
</pre>

## See

*   MISRA C:2004, 13.7 - Boolean operations whose results are invariant shall not be permitted.
*   MISRA C:2012, 14.3 - Controlling expressions shall not be invariant
*   [MITRE, CWE-489](http://cwe.mitre.org/data/definitions/489) - Leftover Debug Code
*   [MITRE, CWE-571](http://cwe.mitre.org/data/definitions/571) - Expression is Always True
*   [CERT, MSC12-C.](https://www.securecoding.cert.org/confluence/x/NYA5) - Detect and remove code that has no effect or is never
      executed
*   [CERT, MSC12-CPP.](https://www.securecoding.cert.org/confluence/x/SIIyAQ) - Detect and remove code that has no effect