A `catch` clause that only rethrows the caught exception has the same effect as omitting the `catch` altogether and letting
it bubble up automatically, but with more code and the additional detrement of leaving maintainers scratching their heads. 

Such clauses should either be eliminated or populated with the appropriate logic.

## Noncompliant Code Example

<pre>
string s = "";
try
{
  s = File.ReadAllText(fileName);
}
catch (Exception e)  // Noncompliant
{
  throw;
}
</pre>

## Compliant Solution

<pre>
string s = "";
try
{
  s = File.ReadAllText(fileName);
}
catch (Exception e) // Compliant
{
  logger.LogError(e);
  throw;
}
</pre>

or

<pre>
string s = File.ReadAllText(fileName);
</pre>

## See

*   [CERT, MSC12-CPP.](https://www.securecoding.cert.org/confluence/x/SIIyAQ) - Detect and remove code that has no effect