A static field in a generic type is not shared among instances of different closed constructed types, thus
`LengthLimitedSingletonCollection<int>.instances` and `LengthLimitedSingletonCollection<string>.instances` will
point to different objects, even though `instances` is seemingly shared among all `LengthLimitedSingletonCollection<>`
generic classes.

If you need to have a static field shared among instances with different generic arguments, define a non-generic base class to store your static
members, then set your generic type to inherit from the base class.

## Noncompliant Code Example

<pre>
public class LengthLimitedSingletonCollection
 <t>
   where T : new()
{
  protected const int MaxAllowedLength = 5;
  protected static Dictionary
  <type, object>
    instances = new Dictionary
   <type, object>
    (); // Noncompliant public static T GetInstance() { object instance; if (!instances.TryGetValue(typeof(T), out instance)) { if (instances.Count &gt;= MaxAllowedLength) { throw new Exception(); } instance = new T(); instances.Add(typeof(T), instance); } return (T)instance; } } 
   </type,>
  </type,>
 </t></pre>

## Compliant Solution

<pre>
public class SingletonCollectionBase
{
  protected static Dictionary
 <type, object>
   instances = new Dictionary
  <type, object>
   (); } public class LengthLimitedSingletonCollection
   <t>
     : SingletonCollectionBase where T : new() { protected const int MaxAllowedLength = 5; public static T GetInstance() { object instance; if (!instances.TryGetValue(typeof(T), out instance)) { if (instances.Count &gt;= MaxAllowedLength) { throw new Exception(); } instance = new T(); instances.Add(typeof(T), instance); } return (T)instance; } } 
   </t>
  </type,>
 </type,></pre>

## Exceptions

If the static field or property uses a type parameter, then the developer is assumed to understand that the static member is not shared among the
closed constructed types.

<pre>
public class Cache
 <t>

{
   private static Dictionary
  <string, t>
    CacheDictionary { get; set; } // Compliant } 
  </string,>
 </t></pre>