While the properties of a `readonly` reference type field can still be changed after initialization, those of a `readonly`
value field, such as a `struct`, cannot. 

If the member could be either a `class` or a `struct` then assignment to its properties could be unreliable, working
sometimes but not others.

## Noncompliant Code Example

<pre>
interface IPoint
{
  int X { get; set; }
  int Y { get; set; }
}

class PointManager
 <t>
   where T: IPoint
{
  readonly T point;  // this could be a struct
  public PointManager(T point)
  {
    this.point = point;
  }

  public void MovePointVertically(int newX)
  {
    point.X = newX; //Noncompliant; if point is a struct, then nothing happened
    Console.WriteLine(point.X);
  }
}

 </t></pre>

## Compliant Solution

<pre>
interface IPoint
{
  int X { get; set; }
  int Y { get; set; }
}

class PointManager
 <t>
   where T : IPoint
{
  readonly T point;  // this could be a struct
  public PointManager(T point)
  {
    this.point = point;
  }

  public void MovePointVertically(int newX) // assignment has been removed
  {
    Console.WriteLine(point.X);
  }
}

 </t></pre>

or

<pre>
interface IPoint
{
  int X { get; set; }
  int Y { get; set; }
}

class PointManager
 <t>
   where T : class, IPoint
{
  readonly T point;  // this can only be a class
  public PointManager(T point)
  {
    this.point = point;
  }

  public void MovePointVertically(int newX)
  {
    point.X = newX;  // this assignment is guaranteed to work
    Console.WriteLine(point.X);
  }
}

 </t></pre>