It's possible to name the members of an inner class the same as the `static` members of its enclosing class - possible, but a bad idea.
That's because maintainers may be confused about which members are being used where. Instead the inner class' members should be renamed and all the
references updated.

## Noncompliant Code Example

<pre>
class Outer
{
  public static int A;

  public class Inner
  {
    public int A; //Noncompliant
    public int MyProp
    {
      get { return A; }  // Returns inner A. Was that intended?
    }
  }
}
</pre>

After a rename

<pre>
class Outer
{
  public static int A;

  public class Inner
  {
    public int B;
    public int MyProp
    {
      get { return A; }  // Still compiles and runs but functionality has changed
    }
  }
}
</pre>

## Compliant Solution

<pre>
class Outer
{
  public static int A;

  public class Inner
  {
    public int InnerA;
    public int MyProp
    {
      get { return InnerA; }
    }
  }
}
</pre>

## See

*   [CERT, DCL51-J.](https://www.securecoding.cert.org/confluence/x/2ADEAw) - Do not shadow or obscure identifiers in subscopes