Redundant parentheses are simply wasted keystrokes, and should be removed.

## Noncompliant Code Example

<pre>
[MyAttribute()] //Noncompliant
class MyClass
{
  public int MyProperty { get; set; }
  public static MyClass CreateNew(int propertyValue)
  {
    return new MyClass() //Noncompliant
    {
      MyProperty = propertyValue
    };
  }
}
</pre>

## Compliant Solution

<pre>
[MyAttribute]
class MyClass
{
  public int MyProperty { get; set; }
  public static MyClass CreateNew(int propertyValue)
  {
    return new MyClass
    {
      MyProperty = propertyValue
    };
  }
}
</pre>

## See

*   [CERT, MSC12-CPP.](https://www.securecoding.cert.org/confluence/x/SIIyAQ) - Detect and remove code that has no effect