Because the `is` operator performs a cast if the object is not null, using `is` to check type and then casting the same
argument to that type, necessarily performs two casts. The same result can be achieved more efficiently with a single cast using `as`,
followed by a null-check.

## Noncompliant Code Example

<pre>
if (x is Fruit)  // Noncompliant
{
  var f = (Fruit)x; // or x as Fruit
  // ...
}
</pre>

## Compliant Solution

<pre>
var f = x as Fruit;
if (f != null)
{
  // code
}
</pre>